unit TestDesktopMain;

interface

uses
  CacheLayout,
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Graphics, FMX.Controls, FMX.Forms, FMX.Dialogs, FMX.StdCtrls, FMX.Layouts, FMX.Edit,
  FMX.Memo, FMX.Objects, FMX.ListBox;

type
  TForm1 = class(TForm)
    StyleBook1: TStyleBook;
    Memo1: TMemo;
    ImageCacheLayout1: TImageCacheLayout;
    Label1: TLabel;
    Edit1: TEdit;
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    Label5: TLabel;
    ComboBox1: TComboBox;
    ListBoxItem1: TListBoxItem;
    MetropolisUIListBoxItem1: TMetropolisUIListBoxItem;
    ListBoxGroupHeader1: TListBoxGroupHeader;
    ListBoxGroupFooter1: TListBoxGroupFooter;
    ListBoxItem2: TListBoxItem;
    AniIndicator1: TAniIndicator;
    Label4: TLabel;
    CheckBox2: TCheckBox;
    btnRepaint: TButton;
    Image1: TImage;
    Button1: TButton;
    Switch1: TSwitch;
    ImageCacheLayout2: TImageCacheLayout;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnRepaintClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Single);
    procedure ImageCacheLayout1MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Single);
    procedure ImageCacheLayout1Paint(Sender: TObject; Canvas: TCanvas; const ARect: TRectF);
    procedure ImageCacheLayout1Painting(Sender: TObject; Canvas: TCanvas; const ARect: TRectF);
  private
    PaintTime: Cardinal;
    procedure Log(aText: String);
  public
    constructor Create(aOwner: TComponent); override;
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

constructor TForm1.Create(aOwner: TComponent);
var
  Time: Cardinal;
begin
  Time := TThread.GetTickCount;
  inherited;
  Time := TThread.GetTickCount - Time;

  Log('Constructor time in ms (to generate an image if not cached): ' + Time.ToString);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ReportMemoryLeaksOnShutdown := true;

  Log('FormCreate');
end;

procedure TForm1.ImageCacheLayout1Painting(Sender: TObject; Canvas: TCanvas; const ARect: TRectF);
begin
  Log('Painting');
  PaintTime := TThread.GetTickCount;
end;

procedure TForm1.ImageCacheLayout1Paint(Sender: TObject; Canvas: TCanvas; const ARect: TRectF);
begin
  PaintTime := TThread.GetTickCount - PaintTime;
  Log('Initial paint time in ms: ' + PaintTime.ToString);
  ImageCacheLayout1.OnPaint := nil;
  ImageCacheLayout1.OnPainting := nil;
end;

procedure TForm1.btnRepaintClick(Sender: TObject);
var
  Time: Cardinal;
begin
  Time := TThread.GetTickCount;

  // Take a screenshot and free it to simulate a paint
  ImageCacheLayout1.MakeScreenshot.Free;

  Time := TThread.GetTickCount - Time;
  Log('Layout repaint time in ms: ' + Time.ToString);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Caption := 'button click';
end;

procedure TForm1.CheckBox1MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Single);
begin
//
end;

procedure TForm1.ImageCacheLayout1MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Single);
begin
  Caption := 'down';
end;

procedure TForm1.Log(aText: String);
begin
  Memo1.Lines.Add(FormatDateTime('hh:nn:ss.zzz', Now) + ' - ' + aText);
end;

end.
